@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.VaultSecretGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies set of certificates that should be installed onto the virtual machines.
 * @property sourceVault The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
 * @property vaultCertificates The list of key vault references in SourceVault which contain certificates.
 */
public data class VaultSecretGroupArgs(
    public val sourceVault: Output<SubResourceArgs>,
    public val vaultCertificates: Output<List<VaultCertificateArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.VaultSecretGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.VaultSecretGroupArgs =
        com.pulumi.azurenative.servicefabric.inputs.VaultSecretGroupArgs.builder()
            .sourceVault(sourceVault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vaultCertificates(
                vaultCertificates.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VaultSecretGroupArgs].
 */
@PulumiTagMarker
public class VaultSecretGroupArgsBuilder internal constructor() {
    private var sourceVault: Output<SubResourceArgs>? = null

    private var vaultCertificates: Output<List<VaultCertificateArgs>>? = null

    /**
     * @param value The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     */
    @JvmName("sstikujoepjqxduq")
    public suspend fun sourceVault(`value`: Output<SubResourceArgs>) {
        this.sourceVault = value
    }

    /**
     * @param value The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("eutjxsbfkftcmxax")
    public suspend fun vaultCertificates(`value`: Output<List<VaultCertificateArgs>>) {
        this.vaultCertificates = value
    }

    @JvmName("dtsjbbkappxtqiwd")
    public suspend fun vaultCertificates(vararg values: Output<VaultCertificateArgs>) {
        this.vaultCertificates = Output.all(values.asList())
    }

    /**
     * @param values The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("xmhdaoldkgwvlmcw")
    public suspend fun vaultCertificates(values: List<Output<VaultCertificateArgs>>) {
        this.vaultCertificates = Output.all(values)
    }

    /**
     * @param value The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     */
    @JvmName("uorngafiquqwkbxq")
    public suspend fun sourceVault(`value`: SubResourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceVault = mapped
    }

    /**
     * @param argument The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     */
    @JvmName("jrsjoqioodeagguv")
    public suspend fun sourceVault(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVault = mapped
    }

    /**
     * @param value The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("alamtlobfswonoou")
    public suspend fun vaultCertificates(`value`: List<VaultCertificateArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultCertificates = mapped
    }

    /**
     * @param argument The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("qytrostemmlpvbhf")
    public suspend
    fun vaultCertificates(argument: List<suspend VaultCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VaultCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vaultCertificates = mapped
    }

    /**
     * @param argument The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("crcuccldpqapbxqi")
    public suspend fun vaultCertificates(
        vararg
        argument: suspend VaultCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VaultCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vaultCertificates = mapped
    }

    /**
     * @param argument The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("mhotanrbkwhwqjvm")
    public suspend fun vaultCertificates(argument: suspend VaultCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VaultCertificateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vaultCertificates = mapped
    }

    /**
     * @param values The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("mspkgmivgbgohdxx")
    public suspend fun vaultCertificates(vararg values: VaultCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultCertificates = mapped
    }

    internal fun build(): VaultSecretGroupArgs = VaultSecretGroupArgs(
        sourceVault = sourceVault ?: throw PulumiNullFieldException("sourceVault"),
        vaultCertificates = vaultCertificates ?: throw PulumiNullFieldException("vaultCertificates"),
    )
}
