@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Describes the maintenance window status of the Service Fabric Managed Cluster.
 * @property canApplyUpdates If updates can be applied.
 * @property isRegionReady Indicates if the region is ready to configure maintenance windows.
 * @property isWindowActive If maintenance window is active.
 * @property isWindowEnabled If maintenance window is enabled on this cluster.
 * @property lastWindowEndTimeUTC Last window end time in UTC.
 * @property lastWindowStartTimeUTC Last window start time in UTC.
 * @property lastWindowStatusUpdateAtUTC Last window update time in UTC.
 */
public data class GetmanagedMaintenanceWindowStatusResult(
    public val canApplyUpdates: Boolean,
    public val isRegionReady: Boolean,
    public val isWindowActive: Boolean,
    public val isWindowEnabled: Boolean,
    public val lastWindowEndTimeUTC: String,
    public val lastWindowStartTimeUTC: String,
    public val lastWindowStatusUpdateAtUTC: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.GetmanagedMaintenanceWindowStatusResult):
            GetmanagedMaintenanceWindowStatusResult = GetmanagedMaintenanceWindowStatusResult(
            canApplyUpdates = javaType.canApplyUpdates(),
            isRegionReady = javaType.isRegionReady(),
            isWindowActive = javaType.isWindowActive(),
            isWindowEnabled = javaType.isWindowEnabled(),
            lastWindowEndTimeUTC = javaType.lastWindowEndTimeUTC(),
            lastWindowStartTimeUTC = javaType.lastWindowStartTimeUTC(),
            lastWindowStatusUpdateAtUTC = javaType.lastWindowStatusUpdateAtUTC(),
        )
    }
}
