@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Creates a particular correlation between services.
 * @property scheme The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
 * @property serviceName The Arm Resource ID of the service that the correlation relationship is established with.
 */
public data class ServiceCorrelationResponse(
    public val scheme: String,
    public val serviceName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ServiceCorrelationResponse):
            ServiceCorrelationResponse = ServiceCorrelationResponse(
            scheme = javaType.scheme(),
            serviceName = javaType.serviceName(),
        )
    }
}
