@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Specifies a metric to load balance a service during runtime.
 * @property defaultLoad Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
 * @property name The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
 * @property primaryDefaultLoad Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
 * @property secondaryDefaultLoad Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
 * @property weight The service load metric relative weight, compared to other metrics configured for this service, as a number.
 */
public data class ServiceLoadMetricResponse(
    public val defaultLoad: Int? = null,
    public val name: String,
    public val primaryDefaultLoad: Int? = null,
    public val secondaryDefaultLoad: Int? = null,
    public val weight: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ServiceLoadMetricResponse):
            ServiceLoadMetricResponse = ServiceLoadMetricResponse(
            defaultLoad = javaType.defaultLoad().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            primaryDefaultLoad = javaType.primaryDefaultLoad().map({ args0 -> args0 }).orElse(null),
            secondaryDefaultLoad = javaType.secondaryDefaultLoad().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
