@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the partition scheme of a singleton-partitioned, or non-partitioned service.
 * @property partitionScheme Enumerates the ways that a service can be partitioned.
 * Expected value is 'Singleton'.
 */
public data class SingletonPartitionSchemeResponse(
    public val partitionScheme: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.SingletonPartitionSchemeResponse):
            SingletonPartitionSchemeResponse = SingletonPartitionSchemeResponse(
            partitionScheme = javaType.partitionScheme(),
        )
    }
}
