@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a stateless service resource.
 * @property correlationScheme A list that describes the correlation of the service with other services.
 * @property defaultMoveCost Specifies the move cost for the service.
 * @property instanceCount The instance count.
 * @property minInstanceCount MinInstanceCount is the minimum number of instances that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstanceCount computation -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
 * @property minInstancePercentage MinInstancePercentage is the minimum percentage of InstanceCount that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstancePercentage computation, -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
 * @property partitionDescription Describes how the service is partitioned.
 * @property placementConstraints The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
 * @property provisioningState The current deployment or provisioning state, which only appears in the response
 * @property scalingPolicies Scaling policies for this service.
 * @property serviceDnsName Dns name used for the service. If this is specified, then the DNS name can be used to return the IP addresses of service endpoints for application layer protocols (e.g., HTTP).
 * When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new name.
 * When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the name being unresolvable.
 * @property serviceKind The kind of service (Stateless or Stateful).
 * Expected value is 'Stateless'.
 * @property serviceLoadMetrics The service load metrics is given as an array of ServiceLoadMetric objects.
 * @property servicePackageActivationMode The activation Mode of the service package
 * @property servicePlacementPolicies A list that describes the correlation of the service with other services.
 * @property serviceTypeName The name of the service type
 */
public data class StatelessServicePropertiesResponse(
    public val correlationScheme: List<ServiceCorrelationResponse>? = null,
    public val defaultMoveCost: String? = null,
    public val instanceCount: Int,
    public val minInstanceCount: Int? = null,
    public val minInstancePercentage: Int? = null,
    public val partitionDescription: Any,
    public val placementConstraints: String? = null,
    public val provisioningState: String,
    public val scalingPolicies: List<ScalingPolicyResponse>? = null,
    public val serviceDnsName: String? = null,
    public val serviceKind: String,
    public val serviceLoadMetrics: List<ServiceLoadMetricResponse>? = null,
    public val servicePackageActivationMode: String? = null,
    public val servicePlacementPolicies: List<Any>? = null,
    public val serviceTypeName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.StatelessServicePropertiesResponse):
            StatelessServicePropertiesResponse = StatelessServicePropertiesResponse(
            correlationScheme = javaType.correlationScheme().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ServiceCorrelationResponse.Companion.toKotlin(args0)
                })
            }),
            defaultMoveCost = javaType.defaultMoveCost().map({ args0 -> args0 }).orElse(null),
            instanceCount = javaType.instanceCount(),
            minInstanceCount = javaType.minInstanceCount().map({ args0 -> args0 }).orElse(null),
            minInstancePercentage = javaType.minInstancePercentage().map({ args0 -> args0 }).orElse(null),
            partitionDescription = javaType.partitionDescription(),
            placementConstraints = javaType.placementConstraints().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            scalingPolicies = javaType.scalingPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ScalingPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            serviceDnsName = javaType.serviceDnsName().map({ args0 -> args0 }).orElse(null),
            serviceKind = javaType.serviceKind(),
            serviceLoadMetrics = javaType.serviceLoadMetrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ServiceLoadMetricResponse.Companion.toKotlin(args0)
                })
            }),
            servicePackageActivationMode = javaType.servicePackageActivationMode().map({ args0 ->
                args0
            }).orElse(null),
            servicePlacementPolicies = javaType.servicePlacementPolicies().map({ args0 -> args0 }),
            serviceTypeName = javaType.serviceTypeName(),
        )
    }
}
