@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies set of extensions that should be installed onto the virtual machines.
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
 * @property forceUpdateTag If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
 * @property name The name of the extension.
 * @property protectedSettings The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
 * @property provisionAfterExtensions Collection of extension names after which this extension needs to be provisioned.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property publisher The name of the extension handler publisher.
 * @property settings Json formatted public settings for the extension.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class VMSSExtensionResponse(
    public val autoUpgradeMinorVersion: Boolean? = null,
    public val enableAutomaticUpgrade: Boolean? = null,
    public val forceUpdateTag: String? = null,
    public val name: String,
    public val protectedSettings: Any? = null,
    public val provisionAfterExtensions: List<String>? = null,
    public val provisioningState: String,
    public val publisher: String,
    public val settings: Any? = null,
    public val type: String,
    public val typeHandlerVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.VMSSExtensionResponse):
            VMSSExtensionResponse = VMSSExtensionResponse(
            autoUpgradeMinorVersion = javaType.autoUpgradeMinorVersion().map({ args0 -> args0 }).orElse(null),
            enableAutomaticUpgrade = javaType.enableAutomaticUpgrade().map({ args0 -> args0 }).orElse(null),
            forceUpdateTag = javaType.forceUpdateTag().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            protectedSettings = javaType.protectedSettings().map({ args0 -> args0 }).orElse(null),
            provisionAfterExtensions = javaType.provisionAfterExtensions().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            publisher = javaType.publisher(),
            settings = javaType.settings().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            typeHandlerVersion = javaType.typeHandlerVersion(),
        )
    }
}
