@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Managed data disk description.
 * @property diskLetter Managed data disk letter. It can not use the reserved letter C or D and it can not change after created.
 * @property diskSizeGB Disk size for each vm in the node type in GBs.
 * @property diskType Managed data disk type. Specifies the storage account type for the managed disk
 * @property lun Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM. Lun 0 is reserved for the service fabric data disk.
 */
public data class VmssDataDiskResponse(
    public val diskLetter: String,
    public val diskSizeGB: Int,
    public val diskType: String,
    public val lun: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.VmssDataDiskResponse):
            VmssDataDiskResponse = VmssDataDiskResponse(
            diskLetter = javaType.diskLetter(),
            diskSizeGB = javaType.diskSizeGB(),
            diskType = javaType.diskType(),
            lun = javaType.lun(),
        )
    }
}
