@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.azurenative.servicefabricmesh.NetworkArgs.builder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.NetworkResourcePropertiesArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.NetworkResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This type describes a network resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * Other available API versions: 2018-07-01-preview.
 * ## Example Usage
 * ### CreateOrUpdateNetwork
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var network = new AzureNative.ServiceFabricMesh.Network("network", new()
 *     {
 *         Location = "EastUS",
 *         NetworkResourceName = "sampleNetwork",
 *         Properties = null,
 *         ResourceGroupName = "sbz_demo",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabricmesh/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabricmesh.NewNetwork(ctx, "network", &servicefabricmesh.NetworkArgs{
 * 			Location:            pulumi.String("EastUS"),
 * 			NetworkResourceName: pulumi.String("sampleNetwork"),
 * 			Properties:          nil,
 * 			ResourceGroupName:   pulumi.String("sbz_demo"),
 * 			Tags:                nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabricmesh.Network;
 * import com.pulumi.azurenative.servicefabricmesh.NetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var network = new Network("network", NetworkArgs.builder()
 *             .location("EastUS")
 *             .networkResourceName("sampleNetwork")
 *             .properties()
 *             .resourceGroupName("sbz_demo")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabricmesh:Network sampleNetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/networks/{networkResourceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property networkResourceName The identity of the network.
 * @property properties Describes properties of a network resource.
 * @property resourceGroupName Azure resource group name
 * @property tags Resource tags.
 */
public data class NetworkArgs(
    public val location: Output<String>? = null,
    public val networkResourceName: Output<String>? = null,
    public val properties: Output<NetworkResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.NetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.NetworkArgs =
        com.pulumi.azurenative.servicefabricmesh.NetworkArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .networkResourceName(networkResourceName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkArgs].
 */
@PulumiTagMarker
public class NetworkArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var networkResourceName: Output<String>? = null

    private var properties: Output<NetworkResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("akejlqrefanricsw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The identity of the network.
     */
    @JvmName("klclemrwrdjmaoic")
    public suspend fun networkResourceName(`value`: Output<String>) {
        this.networkResourceName = value
    }

    /**
     * @param value Describes properties of a network resource.
     */
    @JvmName("phdienmsfjjlyuew")
    public suspend fun properties(`value`: Output<NetworkResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("wivnnpokegbmbwmn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bkrtyahuvhydvqsu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gcschxsbpqtamsce")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The identity of the network.
     */
    @JvmName("tskmfdjbecgmkfqc")
    public suspend fun networkResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkResourceName = mapped
    }

    /**
     * @param value Describes properties of a network resource.
     */
    @JvmName("vbpqmjenqcsjawdv")
    public suspend fun properties(`value`: NetworkResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Describes properties of a network resource.
     */
    @JvmName("tmlrauxoxxntohsd")
    public suspend fun properties(argument: suspend NetworkResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("eglfsrsogdvyvkib")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xayrjadooaantrfb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dflixbrfshmadwpw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkArgs = NetworkArgs(
        location = location,
        networkResourceName = networkResourceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
