@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.azurenative.servicefabricmesh.SecretValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This type describes a value of a secret resource. The name of this resource is the version identifier corresponding to this secret value.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### CreateSecretValue
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var secretValue = new AzureNative.ServiceFabricMesh.SecretValue("secretValue", new()
 *     {
 *         Location = "West US",
 *         ResourceGroupName = "sbz_demo",
 *         SecretResourceName = "dbConnectionString",
 *         SecretValueResourceName = "v1",
 *         Value = "mongodb://contoso123:0Fc3IolnL12312asdfawejunASDF@asdfYXX2t8a97kghVcUzcDv98hawelufhawefafnoQRGwNj2nMPL1Y9qsIr9Srdw==@contoso123.documents.azure.com:10255/mydatabase?ssl=true",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabricmesh/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabricmesh.NewSecretValue(ctx, "secretValue", &servicefabricmesh.SecretValueArgs{
 * 			Location:                pulumi.String("West US"),
 * 			ResourceGroupName:       pulumi.String("sbz_demo"),
 * 			SecretResourceName:      pulumi.String("dbConnectionString"),
 * 			SecretValueResourceName: pulumi.String("v1"),
 * 			Value:                   pulumi.String("mongodb://contoso123:0Fc3IolnL12312asdfawejunASDF@asdfYXX2t8a97kghVcUzcDv98hawelufhawefafnoQRGwNj2nMPL1Y9qsIr9Srdw==@contoso123.documents.azure.com:10255/mydatabase?ssl=true"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabricmesh.SecretValue;
 * import com.pulumi.azurenative.servicefabricmesh.SecretValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var secretValue = new SecretValue("secretValue", SecretValueArgs.builder()
 *             .location("West US")
 *             .resourceGroupName("sbz_demo")
 *             .secretResourceName("dbConnectionString")
 *             .secretValueResourceName("v1")
 *             .value("mongodb://contoso123:0Fc3IolnL12312asdfawejunASDF@asdfYXX2t8a97kghVcUzcDv98hawelufhawefafnoQRGwNj2nMPL1Y9qsIr9Srdw==@contoso123.documents.azure.com:10255/mydatabase?ssl=true")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabricmesh:SecretValue v1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/secrets/{secretResourceName}/values/{secretValueResourceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property resourceGroupName Azure resource group name
 * @property secretResourceName The name of the secret resource.
 * @property secretValueResourceName The name of the secret resource value which is typically the version identifier for the value.
 * @property tags Resource tags.
 * @property value The actual value of the secret.
 */
public data class SecretValueArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretResourceName: Output<String>? = null,
    public val secretValueResourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.SecretValueArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.SecretValueArgs =
        com.pulumi.azurenative.servicefabricmesh.SecretValueArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretResourceName(secretResourceName?.applyValue({ args0 -> args0 }))
            .secretValueResourceName(secretValueResourceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretValueArgs].
 */
@PulumiTagMarker
public class SecretValueArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretResourceName: Output<String>? = null

    private var secretValueResourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kilyoqhulbtiqajp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("cjrnoigmopaqudgy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the secret resource.
     */
    @JvmName("eqkuuayopvxcohlh")
    public suspend fun secretResourceName(`value`: Output<String>) {
        this.secretResourceName = value
    }

    /**
     * @param value The name of the secret resource value which is typically the version identifier for the value.
     */
    @JvmName("opaekweaicscosbp")
    public suspend fun secretValueResourceName(`value`: Output<String>) {
        this.secretValueResourceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("itrakfsdiopbqgom")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The actual value of the secret.
     */
    @JvmName("dhenxnsunabgtsog")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mmibfncxebdbmbxa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("soewxtwjhtaxmniu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the secret resource.
     */
    @JvmName("wexmxjrdtnfklmpe")
    public suspend fun secretResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretResourceName = mapped
    }

    /**
     * @param value The name of the secret resource value which is typically the version identifier for the value.
     */
    @JvmName("snfsdtpvdjjyipnd")
    public suspend fun secretValueResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretValueResourceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xrdujyekydrdxpug")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("pradcvjibcomdjrq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The actual value of the secret.
     */
    @JvmName("duufkruimbdfwsnn")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SecretValueArgs = SecretValueArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        secretResourceName = secretResourceName,
        secretValueResourceName = secretValueResourceName,
        tags = tags,
        `value` = `value`,
    )
}
