@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.DiagnosticsDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the diagnostics options available
 * @property defaultSinkRefs The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
 * @property enabled Status of whether or not sinks are enabled.
 * @property sinks List of supported sinks that can be referenced.
 */
public data class DiagnosticsDescriptionArgs(
    public val defaultSinkRefs: Output<List<String>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val sinks: Output<List<AzureInternalMonitoringPipelineSinkDescriptionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.DiagnosticsDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.DiagnosticsDescriptionArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.DiagnosticsDescriptionArgs.builder()
            .defaultSinkRefs(defaultSinkRefs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .sinks(
                sinks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DiagnosticsDescriptionArgs].
 */
@PulumiTagMarker
public class DiagnosticsDescriptionArgsBuilder internal constructor() {
    private var defaultSinkRefs: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var sinks: Output<List<AzureInternalMonitoringPipelineSinkDescriptionArgs>>? = null

    /**
     * @param value The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
     */
    @JvmName("uvqkbkninhhwppta")
    public suspend fun defaultSinkRefs(`value`: Output<List<String>>) {
        this.defaultSinkRefs = value
    }

    @JvmName("ypvuxgyormkpenli")
    public suspend fun defaultSinkRefs(vararg values: Output<String>) {
        this.defaultSinkRefs = Output.all(values.asList())
    }

    /**
     * @param values The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
     */
    @JvmName("uhqrbqpjoxvxnhyk")
    public suspend fun defaultSinkRefs(values: List<Output<String>>) {
        this.defaultSinkRefs = Output.all(values)
    }

    /**
     * @param value Status of whether or not sinks are enabled.
     */
    @JvmName("mjwnbvbwalnssaxa")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value List of supported sinks that can be referenced.
     */
    @JvmName("arhcjlcjgpkkvgxn")
    public suspend
    fun sinks(`value`: Output<List<AzureInternalMonitoringPipelineSinkDescriptionArgs>>) {
        this.sinks = value
    }

    @JvmName("smjeqltnscltdcqo")
    public suspend fun sinks(
        vararg
        values: Output<AzureInternalMonitoringPipelineSinkDescriptionArgs>,
    ) {
        this.sinks = Output.all(values.asList())
    }

    /**
     * @param values List of supported sinks that can be referenced.
     */
    @JvmName("feqheltiuidlbsap")
    public suspend
    fun sinks(values: List<Output<AzureInternalMonitoringPipelineSinkDescriptionArgs>>) {
        this.sinks = Output.all(values)
    }

    /**
     * @param value The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
     */
    @JvmName("hsykipqvrvhidroo")
    public suspend fun defaultSinkRefs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSinkRefs = mapped
    }

    /**
     * @param values The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
     */
    @JvmName("fkvwrotfcgkxqceq")
    public suspend fun defaultSinkRefs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultSinkRefs = mapped
    }

    /**
     * @param value Status of whether or not sinks are enabled.
     */
    @JvmName("fywxnchwcwdutjam")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value List of supported sinks that can be referenced.
     */
    @JvmName("vljgixocjisjvmyu")
    public suspend fun sinks(`value`: List<AzureInternalMonitoringPipelineSinkDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param argument List of supported sinks that can be referenced.
     */
    @JvmName("hornsfwcosbuiwvn")
    public suspend
    fun sinks(argument: List<suspend AzureInternalMonitoringPipelineSinkDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureInternalMonitoringPipelineSinkDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument List of supported sinks that can be referenced.
     */
    @JvmName("vstkewfymmyrhfcc")
    public suspend fun sinks(
        vararg
        argument: suspend AzureInternalMonitoringPipelineSinkDescriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureInternalMonitoringPipelineSinkDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument List of supported sinks that can be referenced.
     */
    @JvmName("jariotukijkbyynj")
    public suspend
    fun sinks(argument: suspend AzureInternalMonitoringPipelineSinkDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureInternalMonitoringPipelineSinkDescriptionArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param values List of supported sinks that can be referenced.
     */
    @JvmName("ldtvoaxxisalwtkq")
    public suspend fun sinks(vararg values: AzureInternalMonitoringPipelineSinkDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    internal fun build(): DiagnosticsDescriptionArgs = DiagnosticsDescriptionArgs(
        defaultSinkRefs = defaultSinkRefs,
        enabled = enabled,
        sinks = sinks,
    )
}
