@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.EnvironmentVariableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an environment variable for the container.
 * @property name The name of the environment variable.
 * @property value The value of the environment variable.
 */
public data class EnvironmentVariableArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.EnvironmentVariableArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.EnvironmentVariableArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.EnvironmentVariableArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentVariableArgs].
 */
@PulumiTagMarker
public class EnvironmentVariableArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the environment variable.
     */
    @JvmName("qhpyaprmpnhvgqmy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the environment variable.
     */
    @JvmName("pixnatkhirvfvvhl")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the environment variable.
     */
    @JvmName("lsthrkbtcckpjccw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the environment variable.
     */
    @JvmName("kvovmeuoncsrwiky")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EnvironmentVariableArgs = EnvironmentVariableArgs(
        name = name,
        `value` = `value`,
    )
}
