@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.GatewayDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes destination endpoint for routing traffic.
 * @property applicationName Name of the service fabric Mesh application.
 * @property endpointName name of the endpoint in the service.
 * @property serviceName service that contains the endpoint.
 */
public data class GatewayDestinationArgs(
    public val applicationName: Output<String>,
    public val endpointName: Output<String>,
    public val serviceName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.GatewayDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.GatewayDestinationArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.GatewayDestinationArgs.builder()
            .applicationName(applicationName.applyValue({ args0 -> args0 }))
            .endpointName(endpointName.applyValue({ args0 -> args0 }))
            .serviceName(serviceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayDestinationArgs].
 */
@PulumiTagMarker
public class GatewayDestinationArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var endpointName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Name of the service fabric Mesh application.
     */
    @JvmName("wvpocryskjdujufq")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value name of the endpoint in the service.
     */
    @JvmName("ofyefsvfrcnacvoq")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value service that contains the endpoint.
     */
    @JvmName("brqjhsihqwvhokao")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Name of the service fabric Mesh application.
     */
    @JvmName("bjsegenknklrrlee")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value name of the endpoint in the service.
     */
    @JvmName("wemcaujgexdgdkyp")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value service that contains the endpoint.
     */
    @JvmName("kyxtfhsjwtfaqwxg")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): GatewayDestinationArgs = GatewayDestinationArgs(
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
