@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.GetGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gatewayResourceName The identity of the gateway.
 * @property resourceGroupName Azure resource group name
 */
public data class GetGatewayPlainArgs(
    public val gatewayResourceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.GetGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.GetGatewayPlainArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.GetGatewayPlainArgs.builder()
            .gatewayResourceName(gatewayResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetGatewayPlainArgsBuilder internal constructor() {
    private var gatewayResourceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The identity of the gateway.
     */
    @JvmName("dhvaglaopaoaucmj")
    public suspend fun gatewayResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayResourceName = mapped
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("syvbwpssymhvfevt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGatewayPlainArgs = GetGatewayPlainArgs(
        gatewayResourceName = gatewayResourceName ?: throw PulumiNullFieldException("gatewayResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
