@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.GetVolumePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Azure resource group name
 * @property volumeResourceName The identity of the volume.
 */
public data class GetVolumePlainArgs(
    public val resourceGroupName: String,
    public val volumeResourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.GetVolumePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.GetVolumePlainArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.GetVolumePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .volumeResourceName(volumeResourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumePlainArgs].
 */
@PulumiTagMarker
public class GetVolumePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var volumeResourceName: String? = null

    /**
     * @param value Azure resource group name
     */
    @JvmName("hdrwhewwqhcdqrux")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The identity of the volume.
     */
    @JvmName("gpcviqypawswdtpw")
    public suspend fun volumeResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeResourceName = mapped
    }

    internal fun build(): GetVolumePlainArgs = GetVolumePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        volumeResourceName = volumeResourceName ?: throw PulumiNullFieldException("volumeResourceName"),
    )
}
