@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.HttpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the http configuration for external connectivity for this network.
 * @property hosts description for routing.
 * @property name http gateway config name.
 * @property port Specifies the port at which the service endpoint below needs to be exposed.
 */
public data class HttpConfigArgs(
    public val hosts: Output<List<HttpHostConfigArgs>>,
    public val name: Output<String>,
    public val port: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.HttpConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.HttpConfigArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.HttpConfigArgs.builder()
            .hosts(hosts.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpConfigArgs].
 */
@PulumiTagMarker
public class HttpConfigArgsBuilder internal constructor() {
    private var hosts: Output<List<HttpHostConfigArgs>>? = null

    private var name: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value description for routing.
     */
    @JvmName("bxhnorqtkueiyjlr")
    public suspend fun hosts(`value`: Output<List<HttpHostConfigArgs>>) {
        this.hosts = value
    }

    @JvmName("ngpfobiybuqoklyo")
    public suspend fun hosts(vararg values: Output<HttpHostConfigArgs>) {
        this.hosts = Output.all(values.asList())
    }

    /**
     * @param values description for routing.
     */
    @JvmName("xlmqtnjnakmtehkj")
    public suspend fun hosts(values: List<Output<HttpHostConfigArgs>>) {
        this.hosts = Output.all(values)
    }

    /**
     * @param value http gateway config name.
     */
    @JvmName("vxgsocgywwjffbsg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the port at which the service endpoint below needs to be exposed.
     */
    @JvmName("jbnfpgdojoeevryl")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value description for routing.
     */
    @JvmName("twshgywircionfwj")
    public suspend fun hosts(`value`: List<HttpHostConfigArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hosts = mapped
    }

    /**
     * @param argument description for routing.
     */
    @JvmName("tlgrusouehxgishx")
    public suspend fun hosts(argument: List<suspend HttpHostConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HttpHostConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hosts = mapped
    }

    /**
     * @param argument description for routing.
     */
    @JvmName("cawrwxfnlvybnmcv")
    public suspend fun hosts(vararg argument: suspend HttpHostConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HttpHostConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hosts = mapped
    }

    /**
     * @param argument description for routing.
     */
    @JvmName("lncpyflforjcrjaj")
    public suspend fun hosts(argument: suspend HttpHostConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HttpHostConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.hosts = mapped
    }

    /**
     * @param values description for routing.
     */
    @JvmName("uaafeewpdhrdpyhw")
    public suspend fun hosts(vararg values: HttpHostConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hosts = mapped
    }

    /**
     * @param value http gateway config name.
     */
    @JvmName("fftcqvihcqlejyot")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the port at which the service endpoint below needs to be exposed.
     */
    @JvmName("eubnqqokyvlwsqhh")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): HttpConfigArgs = HttpConfigArgs(
        hosts = hosts ?: throw PulumiNullFieldException("hosts"),
        name = name ?: throw PulumiNullFieldException("name"),
        port = port ?: throw PulumiNullFieldException("port"),
    )
}
