@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.NetworkRefArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a network reference in a service.
 * @property endpointRefs A list of endpoints that are exposed on this network.
 * @property name Name of the network
 */
public data class NetworkRefArgs(
    public val endpointRefs: Output<List<EndpointRefArgs>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.NetworkRefArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.NetworkRefArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.NetworkRefArgs.builder()
            .endpointRefs(
                endpointRefs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkRefArgs].
 */
@PulumiTagMarker
public class NetworkRefArgsBuilder internal constructor() {
    private var endpointRefs: Output<List<EndpointRefArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value A list of endpoints that are exposed on this network.
     */
    @JvmName("pugssqseyvuoqcfp")
    public suspend fun endpointRefs(`value`: Output<List<EndpointRefArgs>>) {
        this.endpointRefs = value
    }

    @JvmName("llflhweaiatlrhve")
    public suspend fun endpointRefs(vararg values: Output<EndpointRefArgs>) {
        this.endpointRefs = Output.all(values.asList())
    }

    /**
     * @param values A list of endpoints that are exposed on this network.
     */
    @JvmName("jioiysulucxgkcvl")
    public suspend fun endpointRefs(values: List<Output<EndpointRefArgs>>) {
        this.endpointRefs = Output.all(values)
    }

    /**
     * @param value Name of the network
     */
    @JvmName("ftcexjfferkwymei")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of endpoints that are exposed on this network.
     */
    @JvmName("gvsitjbqkfqlwias")
    public suspend fun endpointRefs(`value`: List<EndpointRefArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointRefs = mapped
    }

    /**
     * @param argument A list of endpoints that are exposed on this network.
     */
    @JvmName("ciwevikcswwtkutw")
    public suspend fun endpointRefs(argument: List<suspend EndpointRefArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { EndpointRefArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.endpointRefs = mapped
    }

    /**
     * @param argument A list of endpoints that are exposed on this network.
     */
    @JvmName("xvlieuyulvwfcspu")
    public suspend fun endpointRefs(vararg argument: suspend EndpointRefArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { EndpointRefArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.endpointRefs = mapped
    }

    /**
     * @param argument A list of endpoints that are exposed on this network.
     */
    @JvmName("ckjyqlkhthfrqxvk")
    public suspend fun endpointRefs(argument: suspend EndpointRefArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EndpointRefArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpointRefs = mapped
    }

    /**
     * @param values A list of endpoints that are exposed on this network.
     */
    @JvmName("oxyntqkwgdxywayy")
    public suspend fun endpointRefs(vararg values: EndpointRefArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointRefs = mapped
    }

    /**
     * @param value Name of the network
     */
    @JvmName("bulasvnioqomydcj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): NetworkRefArgs = NetworkRefArgs(
        endpointRefs = endpointRefs,
        name = name,
    )
}
