@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.ResourceLimitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This type describes the resource limits for a given container. It describes the most amount of resources a container is allowed to use before being restarted.
 * @property cpu CPU limits in cores. At present, only full cores are supported.
 * @property memoryInGB The memory limit in GB.
 */
public data class ResourceLimitsArgs(
    public val cpu: Output<Double>? = null,
    public val memoryInGB: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.ResourceLimitsArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.ResourceLimitsArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.ResourceLimitsArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .memoryInGB(memoryInGB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceLimitsArgs].
 */
@PulumiTagMarker
public class ResourceLimitsArgsBuilder internal constructor() {
    private var cpu: Output<Double>? = null

    private var memoryInGB: Output<Double>? = null

    /**
     * @param value CPU limits in cores. At present, only full cores are supported.
     */
    @JvmName("xghmmcqaovqwbxli")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The memory limit in GB.
     */
    @JvmName("ropwdoarejsomudy")
    public suspend fun memoryInGB(`value`: Output<Double>) {
        this.memoryInGB = value
    }

    /**
     * @param value CPU limits in cores. At present, only full cores are supported.
     */
    @JvmName("jeobjjodwiyfxbmv")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The memory limit in GB.
     */
    @JvmName("rkfqvxllecpjoxnj")
    public suspend fun memoryInGB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryInGB = mapped
    }

    internal fun build(): ResourceLimitsArgs = ResourceLimitsArgs(
        cpu = cpu,
        memoryInGB = memoryInGB,
    )
}
