@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.ResourceRequestsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This type describes the requested resources for a given container. It describes the least amount of resources required for the container. A container can consume more than requested resources up to the specified limits before being restarted. Currently, the requested resources are treated as limits.
 * @property cpu Requested number of CPU cores. At present, only full cores are supported.
 * @property memoryInGB The memory request in GB for this container.
 */
public data class ResourceRequestsArgs(
    public val cpu: Output<Double>,
    public val memoryInGB: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.ResourceRequestsArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.ResourceRequestsArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.ResourceRequestsArgs.builder()
            .cpu(cpu.applyValue({ args0 -> args0 }))
            .memoryInGB(memoryInGB.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceRequestsArgs].
 */
@PulumiTagMarker
public class ResourceRequestsArgsBuilder internal constructor() {
    private var cpu: Output<Double>? = null

    private var memoryInGB: Output<Double>? = null

    /**
     * @param value Requested number of CPU cores. At present, only full cores are supported.
     */
    @JvmName("nqqaqfdagonohpxv")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The memory request in GB for this container.
     */
    @JvmName("auxlshtdgyqynsni")
    public suspend fun memoryInGB(`value`: Output<Double>) {
        this.memoryInGB = value
    }

    /**
     * @param value Requested number of CPU cores. At present, only full cores are supported.
     */
    @JvmName("uffsbvvnwhjjucss")
    public suspend fun cpu(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The memory request in GB for this container.
     */
    @JvmName("trkrdfapspqkqtwc")
    public suspend fun memoryInGB(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memoryInGB = mapped
    }

    internal fun build(): ResourceRequestsArgs = ResourceRequestsArgs(
        cpu = cpu ?: throw PulumiNullFieldException("cpu"),
        memoryInGB = memoryInGB ?: throw PulumiNullFieldException("memoryInGB"),
    )
}
