@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.ResourceRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * This type describes the resource requirements for a container or a service.
 * @property limits Describes the maximum limits on the resources for a given container.
 * @property requests Describes the requested resources for a given container.
 */
public data class ResourceRequirementsArgs(
    public val limits: Output<ResourceLimitsArgs>? = null,
    public val requests: Output<ResourceRequestsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.ResourceRequirementsArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.ResourceRequirementsArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.ResourceRequirementsArgs.builder()
            .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requests(requests.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourceRequirementsArgs].
 */
@PulumiTagMarker
public class ResourceRequirementsArgsBuilder internal constructor() {
    private var limits: Output<ResourceLimitsArgs>? = null

    private var requests: Output<ResourceRequestsArgs>? = null

    /**
     * @param value Describes the maximum limits on the resources for a given container.
     */
    @JvmName("wxsomwqfgwlengsb")
    public suspend fun limits(`value`: Output<ResourceLimitsArgs>) {
        this.limits = value
    }

    /**
     * @param value Describes the requested resources for a given container.
     */
    @JvmName("okiaatltakhxaclv")
    public suspend fun requests(`value`: Output<ResourceRequestsArgs>) {
        this.requests = value
    }

    /**
     * @param value Describes the maximum limits on the resources for a given container.
     */
    @JvmName("dusajtyobmtlrmdj")
    public suspend fun limits(`value`: ResourceLimitsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument Describes the maximum limits on the resources for a given container.
     */
    @JvmName("vvgjcbcamkxjmgab")
    public suspend fun limits(argument: suspend ResourceLimitsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLimitsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value Describes the requested resources for a given container.
     */
    @JvmName("auoatxhstxgaqtef")
    public suspend fun requests(`value`: ResourceRequestsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param argument Describes the requested resources for a given container.
     */
    @JvmName("uqwvcugxwogsfyfj")
    public suspend fun requests(argument: suspend ResourceRequestsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequestsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    internal fun build(): ResourceRequirementsArgs = ResourceRequirementsArgs(
        limits = limits,
        requests = requests ?: throw PulumiNullFieldException("requests"),
    )
}
