@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Describes a volume whose lifetime is scoped to the application's lifetime.
 * @property creationParameters Describes parameters for creating application-scoped volumes.
 * @property destinationPath The path within the container at which the volume should be mounted. Only valid path characters are allowed.
 * @property name Name of the volume being referenced.
 * @property readOnly The flag indicating whether the volume is read only. Default is 'false'.
 */
public data class ApplicationScopedVolumeResponse(
    public val creationParameters:
    ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse,
    public val destinationPath: String,
    public val name: String,
    public val readOnly: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ApplicationScopedVolumeResponse):
            ApplicationScopedVolumeResponse = ApplicationScopedVolumeResponse(
            creationParameters = javaType.creationParameters().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ApplicationScopedVolumeCreationParametersServiceFabricVolumeDiskResponse.Companion.toKotlin(args0)
            }),
            destinationPath = javaType.destinationPath(),
            name = javaType.name(),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
        )
    }
}
