@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes destination endpoint for routing traffic.
 * @property applicationName Name of the service fabric Mesh application.
 * @property endpointName name of the endpoint in the service.
 * @property serviceName service that contains the endpoint.
 */
public data class GatewayDestinationResponse(
    public val applicationName: String,
    public val endpointName: String,
    public val serviceName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.GatewayDestinationResponse):
            GatewayDestinationResponse = GatewayDestinationResponse(
            applicationName = javaType.applicationName(),
            endpointName = javaType.endpointName(),
            serviceName = javaType.serviceName(),
        )
    }
}
