@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * This type describes an application resource.
 * @property debugParams Internal - used by Visual Studio to setup the debugging session on the local development environment.
 * @property description User readable description of the application.
 * @property diagnostics Describes the diagnostics definition and usage for an application resource.
 * @property healthState Describes the health state of an application resource.
 * @property id Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState State of the resource.
 * @property serviceNames Names of the services in the application.
 * @property services Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
 * @property status Status of the application.
 * @property statusDetails Gives additional information about the current status of the application.
 * @property tags Resource tags.
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 * @property unhealthyEvaluation When the application's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the application is marked unhealthy.
 */
public data class GetApplicationResult(
    public val debugParams: String? = null,
    public val description: String? = null,
    public val diagnostics: DiagnosticsDescriptionResponse? = null,
    public val healthState: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val serviceNames: List<String>,
    public val services: List<ServiceResourceDescriptionResponse>? = null,
    public val status: String,
    public val statusDetails: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val unhealthyEvaluation: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.GetApplicationResult):
            GetApplicationResult = GetApplicationResult(
            debugParams = javaType.debugParams().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            diagnostics = javaType.diagnostics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.DiagnosticsDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            healthState = javaType.healthState(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            serviceNames = javaType.serviceNames().map({ args0 -> args0 }),
            services = javaType.services().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ServiceResourceDescriptionResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            statusDetails = javaType.statusDetails(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            unhealthyEvaluation = javaType.unhealthyEvaluation(),
        )
    }
}
