@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the http configuration for external connectivity for this network.
 * @property hosts description for routing.
 * @property name http gateway config name.
 * @property port Specifies the port at which the service endpoint below needs to be exposed.
 */
public data class HttpConfigResponse(
    public val hosts: List<HttpHostConfigResponse>,
    public val name: String,
    public val port: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.HttpConfigResponse):
            HttpConfigResponse = HttpConfigResponse(
            hosts = javaType.hosts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.HttpHostConfigResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            port = javaType.port(),
        )
    }
}
