@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Image registry credential.
 * @property password The password for the private registry. The password is required for create or update operations, however it is not returned in the get or list operations.
 * @property server Docker image registry server, without protocol such as `http` and `https`.
 * @property username The username for the private registry.
 */
public data class ImageRegistryCredentialResponse(
    public val password: String? = null,
    public val server: String,
    public val username: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ImageRegistryCredentialResponse):
            ImageRegistryCredentialResponse = ImageRegistryCredentialResponse(
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            server = javaType.server(),
            username = javaType.username(),
        )
    }
}
