@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a network reference in a service.
 * @property endpointRefs A list of endpoints that are exposed on this network.
 * @property name Name of the network
 */
public data class NetworkRefResponse(
    public val endpointRefs: List<EndpointRefResponse>? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.NetworkRefResponse):
            NetworkRefResponse = NetworkRefResponse(
            endpointRefs = javaType.endpointRefs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.EndpointRefResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
