@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * This type describes the resource limits for a given container. It describes the most amount of resources a container is allowed to use before being restarted.
 * @property cpu CPU limits in cores. At present, only full cores are supported.
 * @property memoryInGB The memory limit in GB.
 */
public data class ResourceLimitsResponse(
    public val cpu: Double? = null,
    public val memoryInGB: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ResourceLimitsResponse):
            ResourceLimitsResponse = ResourceLimitsResponse(
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            memoryInGB = javaType.memoryInGB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
