@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of a secret resource.
 * @property contentType The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the value of this property cannot be changed.
 * @property description User readable description of the secret.
 * @property kind Describes the kind of secret.
 * Expected value is 'SecretResourceProperties'.
 * @property provisioningState State of the resource.
 * @property status Status of the resource.
 * @property statusDetails Gives additional information about the current status of the secret.
 */
public data class SecretResourcePropertiesResponse(
    public val contentType: String? = null,
    public val description: String? = null,
    public val kind: String,
    public val provisioningState: String,
    public val status: String,
    public val statusDetails: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.SecretResourcePropertiesResponse):
            SecretResourcePropertiesResponse = SecretResourcePropertiesResponse(
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            statusDetails = javaType.statusDetails(),
        )
    }
}
