@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin

import com.pulumi.azurenative.servicelinker.ConnectorDryrunArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.inputs.CreateOrUpdateDryrunParametersArgs
import com.pulumi.azurenative.servicelinker.kotlin.inputs.CreateOrUpdateDryrunParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * a dryrun job resource
 * Azure REST API version: 2022-11-01-preview.
 * ## Example Usage
 * ### ConnectorDryrunCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectorDryrun = new AzureNative.ServiceLinker.ConnectorDryrun("connectorDryrun", new()
 *     {
 *         DryrunName = "dryrunName",
 *         Location = "westus",
 *         Parameters = new AzureNative.ServiceLinker.Inputs.CreateOrUpdateDryrunParametersArgs
 *         {
 *             ActionName = "createOrUpdate",
 *             AuthInfo = new AzureNative.ServiceLinker.Inputs.SecretAuthInfoArgs
 *             {
 *                 AuthType = "secret",
 *                 Name = "name",
 *                 SecretInfo = new AzureNative.ServiceLinker.Inputs.ValueSecretInfoArgs
 *                 {
 *                     SecretType = "rawValue",
 *                     Value = "secret",
 *                 },
 *             },
 *             TargetService = new AzureNative.ServiceLinker.Inputs.AzureResourceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db",
 *                 Type = "AzureResource",
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicelinker/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := servicelinker.NewConnectorDryrun(ctx, "connectorDryrun", &servicelinker.ConnectorDryrunArgs{
 * DryrunName: pulumi.String("dryrunName"),
 * Location: pulumi.String("westus"),
 * Parameters: interface{}{
 * ActionName: pulumi.String("createOrUpdate"),
 * AuthInfo: servicelinker.SecretAuthInfo{
 * AuthType: "secret",
 * Name: "name",
 * SecretInfo: servicelinker.ValueSecretInfo{
 * SecretType: "rawValue",
 * Value: "secret",
 * },
 * },
 * TargetService: servicelinker.AzureResource{
 * Id: "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db",
 * Type: "AzureResource",
 * },
 * },
 * ResourceGroupName: pulumi.String("test-rg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicelinker.ConnectorDryrun;
 * import com.pulumi.azurenative.servicelinker.ConnectorDryrunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectorDryrun = new ConnectorDryrun("connectorDryrun", ConnectorDryrunArgs.builder()
 *             .dryrunName("dryrunName")
 *             .location("westus")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("actionName", "createOrUpdate"),
 *                 Map.entry("authInfo", Map.ofEntries(
 *                     Map.entry("authType", "secret"),
 *                     Map.entry("name", "name"),
 *                     Map.entry("secretInfo", Map.ofEntries(
 *                         Map.entry("secretType", "rawValue"),
 *                         Map.entry("value", "secret")
 *                     ))
 *                 )),
 *                 Map.entry("targetService", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db"),
 *                     Map.entry("type", "AzureResource")
 *                 ))
 *             ))
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicelinker:ConnectorDryrun dryrunName /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/dryruns/{dryrunName}
 * ```
 * @property dryrunName The name of dryrun.
 * @property location The name of Azure region.
 * @property parameters The parameters of the dryrun
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subscriptionId The ID of the target subscription.
 */
public data class ConnectorDryrunArgs(
    public val dryrunName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val parameters: Output<CreateOrUpdateDryrunParametersArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.ConnectorDryrunArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.ConnectorDryrunArgs =
        com.pulumi.azurenative.servicelinker.ConnectorDryrunArgs.builder()
            .dryrunName(dryrunName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorDryrunArgs].
 */
@PulumiTagMarker
public class ConnectorDryrunArgsBuilder internal constructor() {
    private var dryrunName: Output<String>? = null

    private var location: Output<String>? = null

    private var parameters: Output<CreateOrUpdateDryrunParametersArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value The name of dryrun.
     */
    @JvmName("jmmbsvlapokdiquh")
    public suspend fun dryrunName(`value`: Output<String>) {
        this.dryrunName = value
    }

    /**
     * @param value The name of Azure region.
     */
    @JvmName("vctxkoeertmtftys")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The parameters of the dryrun
     */
    @JvmName("raxymrklvdphiikv")
    public suspend fun parameters(`value`: Output<CreateOrUpdateDryrunParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xqnexcbyymfdrgpi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The ID of the target subscription.
     */
    @JvmName("mysfbqapmwywlnoa")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The name of dryrun.
     */
    @JvmName("yjiijfkjykveylki")
    public suspend fun dryrunName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryrunName = mapped
    }

    /**
     * @param value The name of Azure region.
     */
    @JvmName("woonqdyqjevbyjcr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The parameters of the dryrun
     */
    @JvmName("mcrgkwtcusmopdnj")
    public suspend fun parameters(`value`: CreateOrUpdateDryrunParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the dryrun
     */
    @JvmName("rdlvrhneblhlghsu")
    public suspend
    fun parameters(argument: suspend CreateOrUpdateDryrunParametersArgsBuilder.() -> Unit) {
        val toBeMapped = CreateOrUpdateDryrunParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gykqqnbeefigjgkk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ID of the target subscription.
     */
    @JvmName("fqunqxqvixpceyki")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): ConnectorDryrunArgs = ConnectorDryrunArgs(
        dryrunName = dryrunName,
        location = location,
        parameters = parameters,
        resourceGroupName = resourceGroupName,
        subscriptionId = subscriptionId,
    )
}
