@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The application client type
 */
public enum class ClientType(
    public val javaValue: com.pulumi.azurenative.servicelinker.enums.ClientType,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.enums.ClientType> {
    None(com.pulumi.azurenative.servicelinker.enums.ClientType.None),
    Dotnet(com.pulumi.azurenative.servicelinker.enums.ClientType.Dotnet),
    Java(com.pulumi.azurenative.servicelinker.enums.ClientType.Java),
    Python(com.pulumi.azurenative.servicelinker.enums.ClientType.Python),
    Go(com.pulumi.azurenative.servicelinker.enums.ClientType.Go),
    Php(com.pulumi.azurenative.servicelinker.enums.ClientType.Php),
    Ruby(com.pulumi.azurenative.servicelinker.enums.ClientType.Ruby),
    Django(com.pulumi.azurenative.servicelinker.enums.ClientType.Django),
    Nodejs(com.pulumi.azurenative.servicelinker.enums.ClientType.Nodejs),
    SpringBoot(com.pulumi.azurenative.servicelinker.enums.ClientType.SpringBoot),
    KafkaspringBoot(com.pulumi.azurenative.servicelinker.enums.ClientType.KafkaspringBoot),
    Dapr(com.pulumi.azurenative.servicelinker.enums.ClientType.Dapr),
    ;

    override fun toJava(): com.pulumi.azurenative.servicelinker.enums.ClientType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.enums.ClientType): ClientType =
            ClientType.values().first { it.javaValue == javaType }
    }
}
