@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.ConfigurationInfoArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.enums.ActionType
import com.pulumi.azurenative.servicelinker.kotlin.enums.DeleteOrUpdateBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The configuration information, used to generate configurations or save to applications
 * @property action Optional, indicate whether to apply configurations on source application. If enable, generate configurations and applied to the source application. Default is enable. If optOut, no configuration change will be made on source.
 * @property additionalConfigurations A dictionary of additional configurations to be added. Service will auto generate a set of basic configurations and this property is to full fill more customized configurations
 * @property customizedKeys Optional. A dictionary of default key name and customized key name mapping. If not specified, default key name will be used for generate configurations
 * @property daprProperties Indicates some additional properties for dapr client type
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 */
public data class ConfigurationInfoArgs(
    public val action: Output<Either<String, ActionType>>? = null,
    public val additionalConfigurations: Output<Map<String, String>>? = null,
    public val customizedKeys: Output<Map<String, String>>? = null,
    public val daprProperties: Output<DaprPropertiesArgs>? = null,
    public val deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.ConfigurationInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.ConfigurationInfoArgs =
        com.pulumi.azurenative.servicelinker.inputs.ConfigurationInfoArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .additionalConfigurations(
                additionalConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .customizedKeys(
                customizedKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .daprProperties(daprProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deleteOrUpdateBehavior(
                deleteOrUpdateBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationInfoArgs].
 */
@PulumiTagMarker
public class ConfigurationInfoArgsBuilder internal constructor() {
    private var action: Output<Either<String, ActionType>>? = null

    private var additionalConfigurations: Output<Map<String, String>>? = null

    private var customizedKeys: Output<Map<String, String>>? = null

    private var daprProperties: Output<DaprPropertiesArgs>? = null

    private var deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null

    /**
     * @param value Optional, indicate whether to apply configurations on source application. If enable, generate configurations and applied to the source application. Default is enable. If optOut, no configuration change will be made on source.
     */
    @JvmName("rmyvnxkdewhigwrb")
    public suspend fun action(`value`: Output<Either<String, ActionType>>) {
        this.action = value
    }

    /**
     * @param value A dictionary of additional configurations to be added. Service will auto generate a set of basic configurations and this property is to full fill more customized configurations
     */
    @JvmName("qlngsmukvkprwbmf")
    public suspend fun additionalConfigurations(`value`: Output<Map<String, String>>) {
        this.additionalConfigurations = value
    }

    /**
     * @param value Optional. A dictionary of default key name and customized key name mapping. If not specified, default key name will be used for generate configurations
     */
    @JvmName("kabbrrsigdtldffh")
    public suspend fun customizedKeys(`value`: Output<Map<String, String>>) {
        this.customizedKeys = value
    }

    /**
     * @param value Indicates some additional properties for dapr client type
     */
    @JvmName("bifgqdosabbdcqjq")
    public suspend fun daprProperties(`value`: Output<DaprPropertiesArgs>) {
        this.daprProperties = value
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("tochgeehkaqcckxl")
    public suspend
    fun deleteOrUpdateBehavior(`value`: Output<Either<String, DeleteOrUpdateBehavior>>) {
        this.deleteOrUpdateBehavior = value
    }

    /**
     * @param value Optional, indicate whether to apply configurations on source application. If enable, generate configurations and applied to the source application. Default is enable. If optOut, no configuration change will be made on source.
     */
    @JvmName("bjgxopqeclttekkn")
    public suspend fun action(`value`: Either<String, ActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Optional, indicate whether to apply configurations on source application. If enable, generate configurations and applied to the source application. Default is enable. If optOut, no configuration change will be made on source.
     */
    @JvmName("recrwvgpgmdekxbg")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Optional, indicate whether to apply configurations on source application. If enable, generate configurations and applied to the source application. Default is enable. If optOut, no configuration change will be made on source.
     */
    @JvmName("gvkcbigjgsdakdim")
    public fun action(`value`: ActionType) {
        val toBeMapped = Either.ofRight<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value A dictionary of additional configurations to be added. Service will auto generate a set of basic configurations and this property is to full fill more customized configurations
     */
    @JvmName("mmngjjisdvisbphf")
    public suspend fun additionalConfigurations(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalConfigurations = mapped
    }

    /**
     * @param values A dictionary of additional configurations to be added. Service will auto generate a set of basic configurations and this property is to full fill more customized configurations
     */
    @JvmName("xdrmjeabwmtfpjsd")
    public fun additionalConfigurations(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalConfigurations = mapped
    }

    /**
     * @param value Optional. A dictionary of default key name and customized key name mapping. If not specified, default key name will be used for generate configurations
     */
    @JvmName("vbkvojwmtmybsdek")
    public suspend fun customizedKeys(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customizedKeys = mapped
    }

    /**
     * @param values Optional. A dictionary of default key name and customized key name mapping. If not specified, default key name will be used for generate configurations
     */
    @JvmName("fyggulnrbxapcjrg")
    public fun customizedKeys(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customizedKeys = mapped
    }

    /**
     * @param value Indicates some additional properties for dapr client type
     */
    @JvmName("anyemtpvmwhbppam")
    public suspend fun daprProperties(`value`: DaprPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daprProperties = mapped
    }

    /**
     * @param argument Indicates some additional properties for dapr client type
     */
    @JvmName("lweqsrqhvkrxxgce")
    public suspend fun daprProperties(argument: suspend DaprPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DaprPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.daprProperties = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("fldriapuyffsjbjy")
    public suspend fun deleteOrUpdateBehavior(`value`: Either<String, DeleteOrUpdateBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("ckagrclbtjeywtdh")
    public fun deleteOrUpdateBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("bvnkmutwcujmobnh")
    public fun deleteOrUpdateBehavior(`value`: DeleteOrUpdateBehavior) {
        val toBeMapped = Either.ofRight<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    internal fun build(): ConfigurationInfoArgs = ConfigurationInfoArgs(
        action = action,
        additionalConfigurations = additionalConfigurations,
        customizedKeys = customizedKeys,
        daprProperties = daprProperties,
        deleteOrUpdateBehavior = deleteOrUpdateBehavior,
    )
}
