@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.ConfluentSchemaRegistryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The service properties when target service type is ConfluentSchemaRegistry
 * @property endpoint The endpoint of service.
 * @property type The target service type.
 * Expected value is 'ConfluentSchemaRegistry'.
 */
public data class ConfluentSchemaRegistryArgs(
    public val endpoint: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.ConfluentSchemaRegistryArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.ConfluentSchemaRegistryArgs =
        com.pulumi.azurenative.servicelinker.inputs.ConfluentSchemaRegistryArgs.builder()
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfluentSchemaRegistryArgs].
 */
@PulumiTagMarker
public class ConfluentSchemaRegistryArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The endpoint of service.
     */
    @JvmName("qvpdrektnkhwfafb")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The target service type.
     * Expected value is 'ConfluentSchemaRegistry'.
     */
    @JvmName("mgygqoibehdsmdhv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The endpoint of service.
     */
    @JvmName("dfrnokdtkinqiaka")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The target service type.
     * Expected value is 'ConfluentSchemaRegistry'.
     */
    @JvmName("tqsugrvgdrkeeoul")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConfluentSchemaRegistryArgs = ConfluentSchemaRegistryArgs(
        endpoint = endpoint,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
