@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.CreateOrUpdateDryrunParametersArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.enums.ClientType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The dryrun parameters for creation or update a linker
 * @property actionName The name of action for you dryrun job.
 * Expected value is 'createOrUpdate'.
 * @property authInfo The authentication type.
 * @property clientType The application client type
 * @property configurationInfo The connection information consumed by applications, including secrets, connection strings.
 * @property publicNetworkSolution The network solution.
 * @property scope connection scope in source service.
 * @property secretStore An option to store secret value in secure place
 * @property targetService The target service properties
 * @property vNetSolution The VNet solution.
 */
public data class CreateOrUpdateDryrunParametersArgs(
    public val actionName: Output<String>,
    public val authInfo: Output<Any>? = null,
    public val clientType: Output<Either<String, ClientType>>? = null,
    public val configurationInfo: Output<ConfigurationInfoArgs>? = null,
    public val publicNetworkSolution: Output<PublicNetworkSolutionArgs>? = null,
    public val scope: Output<String>? = null,
    public val secretStore: Output<SecretStoreArgs>? = null,
    public val targetService: Output<Any>? = null,
    public val vNetSolution: Output<VNetSolutionArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.CreateOrUpdateDryrunParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicelinker.inputs.CreateOrUpdateDryrunParametersArgs =
        com.pulumi.azurenative.servicelinker.inputs.CreateOrUpdateDryrunParametersArgs.builder()
            .actionName(actionName.applyValue({ args0 -> args0 }))
            .authInfo(authInfo?.applyValue({ args0 -> args0 }))
            .clientType(
                clientType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .configurationInfo(configurationInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkSolution(
                publicNetworkSolution?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scope(scope?.applyValue({ args0 -> args0 }))
            .secretStore(secretStore?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetService(targetService?.applyValue({ args0 -> args0 }))
            .vNetSolution(vNetSolution?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CreateOrUpdateDryrunParametersArgs].
 */
@PulumiTagMarker
public class CreateOrUpdateDryrunParametersArgsBuilder internal constructor() {
    private var actionName: Output<String>? = null

    private var authInfo: Output<Any>? = null

    private var clientType: Output<Either<String, ClientType>>? = null

    private var configurationInfo: Output<ConfigurationInfoArgs>? = null

    private var publicNetworkSolution: Output<PublicNetworkSolutionArgs>? = null

    private var scope: Output<String>? = null

    private var secretStore: Output<SecretStoreArgs>? = null

    private var targetService: Output<Any>? = null

    private var vNetSolution: Output<VNetSolutionArgs>? = null

    /**
     * @param value The name of action for you dryrun job.
     * Expected value is 'createOrUpdate'.
     */
    @JvmName("voiucqcjltcpamnb")
    public suspend fun actionName(`value`: Output<String>) {
        this.actionName = value
    }

    /**
     * @param value The authentication type.
     */
    @JvmName("hdrqywbfnlrdthqo")
    public suspend fun authInfo(`value`: Output<Any>) {
        this.authInfo = value
    }

    /**
     * @param value The application client type
     */
    @JvmName("fijsnsedyhfstdsy")
    public suspend fun clientType(`value`: Output<Either<String, ClientType>>) {
        this.clientType = value
    }

    /**
     * @param value The connection information consumed by applications, including secrets, connection strings.
     */
    @JvmName("grntihqlsmsworrv")
    public suspend fun configurationInfo(`value`: Output<ConfigurationInfoArgs>) {
        this.configurationInfo = value
    }

    /**
     * @param value The network solution.
     */
    @JvmName("ftvjrdghovpecuns")
    public suspend fun publicNetworkSolution(`value`: Output<PublicNetworkSolutionArgs>) {
        this.publicNetworkSolution = value
    }

    /**
     * @param value connection scope in source service.
     */
    @JvmName("woxubhkwftubbldb")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value An option to store secret value in secure place
     */
    @JvmName("hhuhgfuwhrsbiufj")
    public suspend fun secretStore(`value`: Output<SecretStoreArgs>) {
        this.secretStore = value
    }

    /**
     * @param value The target service properties
     */
    @JvmName("btmcfivrecaexycu")
    public suspend fun targetService(`value`: Output<Any>) {
        this.targetService = value
    }

    /**
     * @param value The VNet solution.
     */
    @JvmName("yadthxdpiokrrals")
    public suspend fun vNetSolution(`value`: Output<VNetSolutionArgs>) {
        this.vNetSolution = value
    }

    /**
     * @param value The name of action for you dryrun job.
     * Expected value is 'createOrUpdate'.
     */
    @JvmName("aeytpvflyfuapgjk")
    public suspend fun actionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionName = mapped
    }

    /**
     * @param value The authentication type.
     */
    @JvmName("umfnagghjbchrjsp")
    public suspend fun authInfo(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authInfo = mapped
    }

    /**
     * @param value The application client type
     */
    @JvmName("ffarmnrlqbaqggqf")
    public suspend fun clientType(`value`: Either<String, ClientType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientType = mapped
    }

    /**
     * @param value The application client type
     */
    @JvmName("fmpyqndtqlrxmnkg")
    public fun clientType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClientType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientType = mapped
    }

    /**
     * @param value The application client type
     */
    @JvmName("ecmvlgddvbshwvqt")
    public fun clientType(`value`: ClientType) {
        val toBeMapped = Either.ofRight<String, ClientType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientType = mapped
    }

    /**
     * @param value The connection information consumed by applications, including secrets, connection strings.
     */
    @JvmName("pdectrtdnslplfqy")
    public suspend fun configurationInfo(`value`: ConfigurationInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationInfo = mapped
    }

    /**
     * @param argument The connection information consumed by applications, including secrets, connection strings.
     */
    @JvmName("dyhixenevueimsqg")
    public suspend fun configurationInfo(argument: suspend ConfigurationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configurationInfo = mapped
    }

    /**
     * @param value The network solution.
     */
    @JvmName("eebvwuapcrvvdvqb")
    public suspend fun publicNetworkSolution(`value`: PublicNetworkSolutionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkSolution = mapped
    }

    /**
     * @param argument The network solution.
     */
    @JvmName("kqhcaxkyqlavkgli")
    public suspend
    fun publicNetworkSolution(argument: suspend PublicNetworkSolutionArgsBuilder.() -> Unit) {
        val toBeMapped = PublicNetworkSolutionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicNetworkSolution = mapped
    }

    /**
     * @param value connection scope in source service.
     */
    @JvmName("bgjnxbeilptlcftc")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value An option to store secret value in secure place
     */
    @JvmName("cpfxjoyvjecskemb")
    public suspend fun secretStore(`value`: SecretStoreArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStore = mapped
    }

    /**
     * @param argument An option to store secret value in secure place
     */
    @JvmName("nfwdkcgbevkxuvak")
    public suspend fun secretStore(argument: suspend SecretStoreArgsBuilder.() -> Unit) {
        val toBeMapped = SecretStoreArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secretStore = mapped
    }

    /**
     * @param value The target service properties
     */
    @JvmName("vwpavtlujrhxvuck")
    public suspend fun targetService(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetService = mapped
    }

    /**
     * @param value The VNet solution.
     */
    @JvmName("npctnacvxgwagody")
    public suspend fun vNetSolution(`value`: VNetSolutionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vNetSolution = mapped
    }

    /**
     * @param argument The VNet solution.
     */
    @JvmName("rmhksiifkgvunxif")
    public suspend fun vNetSolution(argument: suspend VNetSolutionArgsBuilder.() -> Unit) {
        val toBeMapped = VNetSolutionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vNetSolution = mapped
    }

    internal fun build(): CreateOrUpdateDryrunParametersArgs = CreateOrUpdateDryrunParametersArgs(
        actionName = actionName ?: throw PulumiNullFieldException("actionName"),
        authInfo = authInfo,
        clientType = clientType,
        configurationInfo = configurationInfo,
        publicNetworkSolution = publicNetworkSolution,
        scope = scope,
        secretStore = secretStore,
        targetService = targetService,
        vNetSolution = vNetSolution,
    )
}
