@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.DaprMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The dapr component metadata.
 * @property name Metadata property name.
 * @property secretRef The secret name where dapr could get value
 * @property value Metadata property value.
 */
public data class DaprMetadataArgs(
    public val name: Output<String>? = null,
    public val secretRef: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.DaprMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.DaprMetadataArgs =
        com.pulumi.azurenative.servicelinker.inputs.DaprMetadataArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .secretRef(secretRef?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprMetadataArgs].
 */
@PulumiTagMarker
public class DaprMetadataArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var secretRef: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Metadata property name.
     */
    @JvmName("vbrvrmqcoaihoqxs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The secret name where dapr could get value
     */
    @JvmName("ocnlfwodbultcrju")
    public suspend fun secretRef(`value`: Output<String>) {
        this.secretRef = value
    }

    /**
     * @param value Metadata property value.
     */
    @JvmName("yqqieyxxprwwuucj")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Metadata property name.
     */
    @JvmName("jusxcmnwbeubkwcq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The secret name where dapr could get value
     */
    @JvmName("mmjtlddiebrwdivf")
    public suspend fun secretRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretRef = mapped
    }

    /**
     * @param value Metadata property value.
     */
    @JvmName("vijvsthwxvppeglg")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DaprMetadataArgs = DaprMetadataArgs(
        name = name,
        secretRef = secretRef,
        `value` = `value`,
    )
}
