@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.DaprPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Indicates some additional properties for dapr client type
 * @property componentType The dapr component type
 * @property metadata Additional dapr metadata
 * @property scopes The dapr component scopes
 * @property secretStoreComponent The name of a secret store dapr to retrieve secret
 * @property version The dapr component version
 */
public data class DaprPropertiesArgs(
    public val componentType: Output<String>? = null,
    public val metadata: Output<List<DaprMetadataArgs>>? = null,
    public val scopes: Output<List<String>>? = null,
    public val secretStoreComponent: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.DaprPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.DaprPropertiesArgs =
        com.pulumi.azurenative.servicelinker.inputs.DaprPropertiesArgs.builder()
            .componentType(componentType?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .secretStoreComponent(secretStoreComponent?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprPropertiesArgs].
 */
@PulumiTagMarker
public class DaprPropertiesArgsBuilder internal constructor() {
    private var componentType: Output<String>? = null

    private var metadata: Output<List<DaprMetadataArgs>>? = null

    private var scopes: Output<List<String>>? = null

    private var secretStoreComponent: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The dapr component type
     */
    @JvmName("jdoggsbsrgeknmhg")
    public suspend fun componentType(`value`: Output<String>) {
        this.componentType = value
    }

    /**
     * @param value Additional dapr metadata
     */
    @JvmName("gbgxdystgjhlqphe")
    public suspend fun metadata(`value`: Output<List<DaprMetadataArgs>>) {
        this.metadata = value
    }

    @JvmName("cahgynjrsdjtkkqe")
    public suspend fun metadata(vararg values: Output<DaprMetadataArgs>) {
        this.metadata = Output.all(values.asList())
    }

    /**
     * @param values Additional dapr metadata
     */
    @JvmName("qxveupkvenlplcjk")
    public suspend fun metadata(values: List<Output<DaprMetadataArgs>>) {
        this.metadata = Output.all(values)
    }

    /**
     * @param value The dapr component scopes
     */
    @JvmName("ueedjmsepvmmjmnk")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("lyenummlekleimqv")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values The dapr component scopes
     */
    @JvmName("nuxnrgwdchaptexi")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value The name of a secret store dapr to retrieve secret
     */
    @JvmName("xaeuxojeehyyiphj")
    public suspend fun secretStoreComponent(`value`: Output<String>) {
        this.secretStoreComponent = value
    }

    /**
     * @param value The dapr component version
     */
    @JvmName("lhngpxpdugevsjyh")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The dapr component type
     */
    @JvmName("lnopfikijmefjykt")
    public suspend fun componentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentType = mapped
    }

    /**
     * @param value Additional dapr metadata
     */
    @JvmName("dmtafufskknnsghh")
    public suspend fun metadata(`value`: List<DaprMetadataArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Additional dapr metadata
     */
    @JvmName("mkjiqlfhvhtaqpkc")
    public suspend fun metadata(argument: List<suspend DaprMetadataArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DaprMetadataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Additional dapr metadata
     */
    @JvmName("mwcycspwjpnqaehj")
    public suspend fun metadata(vararg argument: suspend DaprMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DaprMetadataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Additional dapr metadata
     */
    @JvmName("ninhgacfemsyfbwh")
    public suspend fun metadata(argument: suspend DaprMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DaprMetadataArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param values Additional dapr metadata
     */
    @JvmName("ywndamqgtopsmlgv")
    public suspend fun metadata(vararg values: DaprMetadataArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The dapr component scopes
     */
    @JvmName("nroxkmockvmiodvu")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values The dapr component scopes
     */
    @JvmName("nplhcqvohlotvdrl")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value The name of a secret store dapr to retrieve secret
     */
    @JvmName("avtjvrtkevplmqyh")
    public suspend fun secretStoreComponent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStoreComponent = mapped
    }

    /**
     * @param value The dapr component version
     */
    @JvmName("abekvyfccmgcgnqd")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): DaprPropertiesArgs = DaprPropertiesArgs(
        componentType = componentType,
        metadata = metadata,
        scopes = scopes,
        secretStoreComponent = secretStoreComponent,
        version = version,
    )
}
