@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.GetLinkerDryrunPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dryrunName The name of dryrun.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
 */
public data class GetLinkerDryrunPlainArgs(
    public val dryrunName: String,
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.GetLinkerDryrunPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.GetLinkerDryrunPlainArgs =
        com.pulumi.azurenative.servicelinker.inputs.GetLinkerDryrunPlainArgs.builder()
            .dryrunName(dryrunName.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLinkerDryrunPlainArgs].
 */
@PulumiTagMarker
public class GetLinkerDryrunPlainArgsBuilder internal constructor() {
    private var dryrunName: String? = null

    private var resourceUri: String? = null

    /**
     * @param value The name of dryrun.
     */
    @JvmName("acjbxvrjihkmtlgq")
    public suspend fun dryrunName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dryrunName = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("iqcxlmowidlcvjsg")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetLinkerDryrunPlainArgs = GetLinkerDryrunPlainArgs(
        dryrunName = dryrunName ?: throw PulumiNullFieldException("dryrunName"),
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
