@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.KeyVaultSecretUriSecretInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The secret info when type is keyVaultSecretUri. It's for scenario that user provides a secret stored in user's keyvault and source is Web App, Spring Cloud or Container App.
 * @property secretType The secret type.
 * Expected value is 'keyVaultSecretUri'.
 * @property value URI to the keyvault secret
 */
public data class KeyVaultSecretUriSecretInfoArgs(
    public val secretType: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.KeyVaultSecretUriSecretInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.KeyVaultSecretUriSecretInfoArgs =
        com.pulumi.azurenative.servicelinker.inputs.KeyVaultSecretUriSecretInfoArgs.builder()
            .secretType(secretType.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultSecretUriSecretInfoArgs].
 */
@PulumiTagMarker
public class KeyVaultSecretUriSecretInfoArgsBuilder internal constructor() {
    private var secretType: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The secret type.
     * Expected value is 'keyVaultSecretUri'.
     */
    @JvmName("fsbnfseiqfrkqwal")
    public suspend fun secretType(`value`: Output<String>) {
        this.secretType = value
    }

    /**
     * @param value URI to the keyvault secret
     */
    @JvmName("xpqetimmebqeddue")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The secret type.
     * Expected value is 'keyVaultSecretUri'.
     */
    @JvmName("qnbuggrblpkbaphe")
    public suspend fun secretType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretType = mapped
    }

    /**
     * @param value URI to the keyvault secret
     */
    @JvmName("jisoyxiguojvhpis")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): KeyVaultSecretUriSecretInfoArgs = KeyVaultSecretUriSecretInfoArgs(
        secretType = secretType ?: throw PulumiNullFieldException("secretType"),
        `value` = `value`,
    )
}
