@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.ServicePrincipalSecretAuthInfoArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.enums.DeleteOrUpdateBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The authentication info when authType is servicePrincipal secret
 * @property authType The authentication type.
 * Expected value is 'servicePrincipalSecret'.
 * @property clientId ServicePrincipal application clientId for servicePrincipal auth.
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 * @property principalId Principal Id for servicePrincipal auth.
 * @property roles Optional, this value specifies the Azure roles to be assigned. Automatically
 * @property secret Secret for servicePrincipal auth.
 * @property userName Username created in the database which is mapped to a user in AAD.
 */
public data class ServicePrincipalSecretAuthInfoArgs(
    public val authType: Output<String>,
    public val clientId: Output<String>,
    public val deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null,
    public val principalId: Output<String>,
    public val roles: Output<List<String>>? = null,
    public val secret: Output<String>,
    public val userName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.ServicePrincipalSecretAuthInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicelinker.inputs.ServicePrincipalSecretAuthInfoArgs =
        com.pulumi.azurenative.servicelinker.inputs.ServicePrincipalSecretAuthInfoArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .deleteOrUpdateBehavior(
                deleteOrUpdateBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .principalId(principalId.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .secret(secret.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePrincipalSecretAuthInfoArgs].
 */
@PulumiTagMarker
public class ServicePrincipalSecretAuthInfoArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var clientId: Output<String>? = null

    private var deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null

    private var principalId: Output<String>? = null

    private var roles: Output<List<String>>? = null

    private var secret: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The authentication type.
     * Expected value is 'servicePrincipalSecret'.
     */
    @JvmName("gwevvdmsacrbfsye")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value ServicePrincipal application clientId for servicePrincipal auth.
     */
    @JvmName("ltwgbkjxonttrnqs")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("dcgijvxghmenakib")
    public suspend
    fun deleteOrUpdateBehavior(`value`: Output<Either<String, DeleteOrUpdateBehavior>>) {
        this.deleteOrUpdateBehavior = value
    }

    /**
     * @param value Principal Id for servicePrincipal auth.
     */
    @JvmName("qxqgjvodcjacurpx")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("bjawfkppqhehjxyo")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("lwbpookvkinodnpt")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("ogepmgfwwcrmpmsn")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value Secret for servicePrincipal auth.
     */
    @JvmName("roxgomvcufqwlgpr")
    public suspend fun secret(`value`: Output<String>) {
        this.secret = value
    }

    /**
     * @param value Username created in the database which is mapped to a user in AAD.
     */
    @JvmName("phflwfbyhfymmuxl")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The authentication type.
     * Expected value is 'servicePrincipalSecret'.
     */
    @JvmName("lgjoxqwcfvraeylx")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value ServicePrincipal application clientId for servicePrincipal auth.
     */
    @JvmName("waovoljcbooeaihr")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("fadabhpuocovnhts")
    public suspend fun deleteOrUpdateBehavior(`value`: Either<String, DeleteOrUpdateBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("sxnytstpiuheqeag")
    public fun deleteOrUpdateBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("spuiincubevspsbm")
    public fun deleteOrUpdateBehavior(`value`: DeleteOrUpdateBehavior) {
        val toBeMapped = Either.ofRight<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Principal Id for servicePrincipal auth.
     */
    @JvmName("tmqstdhmmsihducb")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("yitcolkakablqyqn")
    public suspend fun roles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("utmrwlslabolhmap")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value Secret for servicePrincipal auth.
     */
    @JvmName("saueibfpfqdqpudu")
    public suspend fun secret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    /**
     * @param value Username created in the database which is mapped to a user in AAD.
     */
    @JvmName("klhkjubxkntdatxd")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ServicePrincipalSecretAuthInfoArgs = ServicePrincipalSecretAuthInfoArgs(
        authType = authType ?: throw PulumiNullFieldException("authType"),
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        deleteOrUpdateBehavior = deleteOrUpdateBehavior,
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
        roles = roles,
        secret = secret ?: throw PulumiNullFieldException("secret"),
        userName = userName,
    )
}
