@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The access key directly from target resource properties, which target service is Azure Resource, such as Microsoft.Storage
 * @property authType The authentication type.
 * Expected value is 'accessKey'.
 * @property permissions Permissions of the accessKey. `Read` and `Write` are for Azure Cosmos DB and Azure App Configuration, `Listen`, `Send` and `Manage` are for Azure Event Hub and Azure Service Bus.
 */
public data class AccessKeyInfoBaseResponse(
    public val authType: String,
    public val permissions: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.AccessKeyInfoBaseResponse):
            AccessKeyInfoBaseResponse = AccessKeyInfoBaseResponse(
            authType = javaType.authType(),
            permissions = javaType.permissions().map({ args0 -> args0 }),
        )
    }
}
