@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The resource properties when type is Azure Key Vault
 * @property connectAsKubernetesCsiDriver True if connect via Kubernetes CSI Driver.
 * @property type The azure resource type.
 * Expected value is 'KeyVault'.
 */
public data class AzureKeyVaultPropertiesResponse(
    public val connectAsKubernetesCsiDriver: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.AzureKeyVaultPropertiesResponse):
            AzureKeyVaultPropertiesResponse = AzureKeyVaultPropertiesResponse(
            connectAsKubernetesCsiDriver = javaType.connectAsKubernetesCsiDriver().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
