@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin.inputs

import com.pulumi.azurenative.servicenetworking.inputs.GetTrafficControllerInterfacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property trafficControllerName traffic controller name for path
 */
public data class GetTrafficControllerInterfacePlainArgs(
    public val resourceGroupName: String,
    public val trafficControllerName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicenetworking.inputs.GetTrafficControllerInterfacePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicenetworking.inputs.GetTrafficControllerInterfacePlainArgs =
        com.pulumi.azurenative.servicenetworking.inputs.GetTrafficControllerInterfacePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .trafficControllerName(trafficControllerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficControllerInterfacePlainArgs].
 */
@PulumiTagMarker
public class GetTrafficControllerInterfacePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var trafficControllerName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("igeuggjvbcsaysua")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("noijcobfcotmbdtp")
    public suspend fun trafficControllerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trafficControllerName = mapped
    }

    internal fun build(): GetTrafficControllerInterfacePlainArgs =
        GetTrafficControllerInterfacePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            trafficControllerName = trafficControllerName ?: throw
                PulumiNullFieldException("trafficControllerName"),
        )
}
