@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Represents the identity type: systemAssigned, userAssigned, None
 */
public enum class ManagedIdentityType(
    public val javaValue: com.pulumi.azurenative.signalrservice.enums.ManagedIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.enums.ManagedIdentityType> {
    None(com.pulumi.azurenative.signalrservice.enums.ManagedIdentityType.None),
    SystemAssigned(com.pulumi.azurenative.signalrservice.enums.ManagedIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.signalrservice.enums.ManagedIdentityType.UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.signalrservice.enums.ManagedIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.enums.ManagedIdentityType):
            ManagedIdentityType = ManagedIdentityType.values().first { it.javaValue == javaType }
    }
}
