@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public enum class PrivateLinkServiceConnectionStatus(
    public val javaValue:
    com.pulumi.azurenative.signalrservice.enums.PrivateLinkServiceConnectionStatus,
) :
    ConvertibleToJava<com.pulumi.azurenative.signalrservice.enums.PrivateLinkServiceConnectionStatus> {
    Pending(com.pulumi.azurenative.signalrservice.enums.PrivateLinkServiceConnectionStatus.Pending),
    Approved(com.pulumi.azurenative.signalrservice.enums.PrivateLinkServiceConnectionStatus.Approved),
    Rejected(com.pulumi.azurenative.signalrservice.enums.PrivateLinkServiceConnectionStatus.Rejected),
    Disconnected(com.pulumi.azurenative.signalrservice.enums.PrivateLinkServiceConnectionStatus.Disconnected),
    ;

    override fun toJava():
        com.pulumi.azurenative.signalrservice.enums.PrivateLinkServiceConnectionStatus = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.enums.PrivateLinkServiceConnectionStatus):
            PrivateLinkServiceConnectionStatus =
            PrivateLinkServiceConnectionStatus.values().first { it.javaValue == javaType }
    }
}
