@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.PrivateEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Private endpoint
 * @property id Full qualified Id of the private endpoint
 */
public data class PrivateEndpointArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.PrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.PrivateEndpointArgs =
        com.pulumi.azurenative.signalrservice.inputs.PrivateEndpointArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointArgs].
 */
@PulumiTagMarker
public class PrivateEndpointArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Full qualified Id of the private endpoint
     */
    @JvmName("qgoonktwnqgucpur")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Full qualified Id of the private endpoint
     */
    @JvmName("qaprbcnpobaylxpb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): PrivateEndpointArgs = PrivateEndpointArgs(
        id = id,
    )
}
