@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.ServerlessSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Serverless settings.
 * @property connectionTimeoutInSeconds Gets or sets Client Connection Timeout. Optional to be set.
 * Value in seconds.
 * Default value is 30 seconds.
 * Customer should set the timeout to a shorter period if messages are expected to be sent in shorter intervals,
 * and want the client to disconnect more quickly after the last message is sent.
 * You can set the timeout to a longer period if messages are expected to be sent in longer intervals,
 * and they want to keep the same client connection alive during this session.
 * The service considers the client disconnected if it hasn't received a message (including keep-alive) in this interval.
 */
public data class ServerlessSettingsArgs(
    public val connectionTimeoutInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.ServerlessSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.ServerlessSettingsArgs =
        com.pulumi.azurenative.signalrservice.inputs.ServerlessSettingsArgs.builder()
            .connectionTimeoutInSeconds(connectionTimeoutInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessSettingsArgs].
 */
@PulumiTagMarker
public class ServerlessSettingsArgsBuilder internal constructor() {
    private var connectionTimeoutInSeconds: Output<Int>? = null

    /**
     * @param value Gets or sets Client Connection Timeout. Optional to be set.
     * Value in seconds.
     * Default value is 30 seconds.
     * Customer should set the timeout to a shorter period if messages are expected to be sent in shorter intervals,
     * and want the client to disconnect more quickly after the last message is sent.
     * You can set the timeout to a longer period if messages are expected to be sent in longer intervals,
     * and they want to keep the same client connection alive during this session.
     * The service considers the client disconnected if it hasn't received a message (including keep-alive) in this interval.
     */
    @JvmName("pcfyofbyhnhfgihc")
    public suspend fun connectionTimeoutInSeconds(`value`: Output<Int>) {
        this.connectionTimeoutInSeconds = value
    }

    /**
     * @param value Gets or sets Client Connection Timeout. Optional to be set.
     * Value in seconds.
     * Default value is 30 seconds.
     * Customer should set the timeout to a shorter period if messages are expected to be sent in shorter intervals,
     * and want the client to disconnect more quickly after the last message is sent.
     * You can set the timeout to a longer period if messages are expected to be sent in longer intervals,
     * and they want to keep the same client connection alive during this session.
     * The service considers the client disconnected if it hasn't received a message (including keep-alive) in this interval.
     */
    @JvmName("hekmsangkpkcmmcb")
    public suspend fun connectionTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionTimeoutInSeconds = mapped
    }

    internal fun build(): ServerlessSettingsArgs = ServerlessSettingsArgs(
        connectionTimeoutInSeconds = connectionTimeoutInSeconds,
    )
}
