@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of user assigned identity.
 * @property clientId Get the client id for the user assigned identity
 * @property principalId Get the principal id for the user assigned identity
 */
public data class UserAssignedIdentityPropertyResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.UserAssignedIdentityPropertyResponse):
            UserAssignedIdentityPropertyResponse = UserAssignedIdentityPropertyResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
