@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.softwareplan.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Response on GET of a hybrid use benefit
 * @property createdDate Created date
 * @property etag Indicates the revision of the hybrid use benefit
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastUpdatedDate Last updated date
 * @property name The name of the resource
 * @property provisioningState Provisioning state
 * @property sku Hybrid use benefit SKU
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetHybridUseBenefitResult(
    public val createdDate: String,
    public val etag: Int,
    public val id: String,
    public val lastUpdatedDate: String,
    public val name: String,
    public val provisioningState: String,
    public val sku: SkuResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.softwareplan.outputs.GetHybridUseBenefitResult):
            GetHybridUseBenefitResult = GetHybridUseBenefitResult(
            createdDate = javaType.createdDate(),
            etag = javaType.etag(),
            id = javaType.id(),
            lastUpdatedDate = javaType.lastUpdatedDate(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.softwareplan.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
