@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin

import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationArtifactResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationAuthorizationResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationBillingDetailsDefinitionResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationClientDetailsResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationJitAccessPolicyResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationPackageContactResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationPackageSupportUrlsResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.PlanResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationArtifactResponse.Companion.toKotlin as applicationArtifactResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationAuthorizationResponse.Companion.toKotlin as applicationAuthorizationResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationBillingDetailsDefinitionResponse.Companion.toKotlin as applicationBillingDetailsDefinitionResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationClientDetailsResponse.Companion.toKotlin as applicationClientDetailsResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationJitAccessPolicyResponse.Companion.toKotlin as applicationJitAccessPolicyResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationPackageContactResponse.Companion.toKotlin as applicationPackageContactResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationPackageSupportUrlsResponse.Companion.toKotlin as applicationPackageSupportUrlsResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.PlanResponse.Companion.toKotlin as planResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.azurenative.solutions.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * Information about managed application.
 * Azure REST API version: 2021-07-01. Prior API version in Azure Native 1.x: 2019-07-01.
 * Other available API versions: 2017-12-01, 2018-06-01.
 * ## Example Usage
 * ### Create or update managed application
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.Solutions.Application("application", new()
 *     {
 *         ApplicationDefinitionId = "/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Solutions/applicationDefinitions/myAppDef",
 *         ApplicationName = "myManagedApplication",
 *         Kind = "ServiceCatalog",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/solutions/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := solutions.NewApplication(ctx, "application", &solutions.ApplicationArgs{
 * 			ApplicationDefinitionId: pulumi.String("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Solutions/applicationDefinitions/myAppDef"),
 * 			ApplicationName:         pulumi.String("myManagedApplication"),
 * 			Kind:                    pulumi.String("ServiceCatalog"),
 * 			ManagedResourceGroupId:  pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			ResourceGroupName:       pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.solutions.Application;
 * import com.pulumi.azurenative.solutions.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationDefinitionId("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Solutions/applicationDefinitions/myAppDef")
 *             .applicationName("myManagedApplication")
 *             .kind("ServiceCatalog")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:solutions:Application myManagedApplication /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applications/{applicationName}
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.azurenative.solutions.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * The fully qualified path of managed application definition Id.
     */
    public val applicationDefinitionId: Output<String>?
        get() = javaResource.applicationDefinitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The collection of managed application artifacts.
     */
    public val artifacts: Output<List<ApplicationArtifactResponse>>
        get() = javaResource.artifacts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationArtifactResponseToKotlin(args0)
                })
            })
        })

    /**
     * The  read-only authorizations property that is retrieved from the application package.
     */
    public val authorizations: Output<List<ApplicationAuthorizationResponse>>
        get() = javaResource.authorizations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationAuthorizationResponseToKotlin(args0) })
            })
        })

    /**
     * The managed application billing details.
     */
    public val billingDetails: Output<ApplicationBillingDetailsDefinitionResponse>
        get() = javaResource.billingDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationBillingDetailsDefinitionResponseToKotlin(args0)
            })
        })

    /**
     * The client entity that created the JIT request.
     */
    public val createdBy: Output<ApplicationClientDetailsResponse>
        get() = javaResource.createdBy().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationClientDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The read-only customer support property that is retrieved from the application package.
     */
    public val customerSupport: Output<ApplicationPackageContactResponse>
        get() = javaResource.customerSupport().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationPackageContactResponseToKotlin(args0)
            })
        })

    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The managed application Jit access policy.
     */
    public val jitAccessPolicy: Output<ApplicationJitAccessPolicyResponse>?
        get() = javaResource.jitAccessPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationJitAccessPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ID of the resource that manages this resource.
     */
    public val managedBy: Output<String>?
        get() = javaResource.managedBy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The managed resource group Id.
     */
    public val managedResourceGroupId: Output<String>?
        get() = javaResource.managedResourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The managed application management mode.
     */
    public val managementMode: Output<String>
        get() = javaResource.managementMode().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Name and value pairs that define the managed application outputs.
     */
    public val outputs: Output<Any>
        get() = javaResource.outputs().applyValue({ args0 -> args0 })

    /**
     * Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
     */
    public val parameters: Output<Any>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The plan information.
     */
    public val plan: Output<PlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    planResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The managed application provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The publisher tenant Id.
     */
    public val publisherTenantId: Output<String>
        get() = javaResource.publisherTenantId().applyValue({ args0 -> args0 })

    /**
     * The SKU of the resource.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The read-only support URLs property that is retrieved from the application package.
     */
    public val supportUrls: Output<ApplicationPackageSupportUrlsResponse>
        get() = javaResource.supportUrls().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationPackageSupportUrlsResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The client entity that last updated the JIT request.
     */
    public val updatedBy: Output<ApplicationClientDetailsResponse>
        get() = javaResource.updatedBy().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationClientDetailsResponseToKotlin(args0)
            })
        })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.solutions.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.azurenative.solutions.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit):
    Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
