@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin

import com.pulumi.azurenative.solutions.JitRequestArgs.builder
import com.pulumi.azurenative.solutions.kotlin.inputs.JitAuthorizationPoliciesArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.JitAuthorizationPoliciesArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.JitSchedulingPolicyArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.JitSchedulingPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information about JIT request definition.
 * Azure REST API version: 2021-07-01. Prior API version in Azure Native 1.x: 2019-07-01.
 * ## Example Usage
 * ### Create or update jit request
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jitRequest = new AzureNative.Solutions.JitRequest("jitRequest", new()
 *     {
 *         ApplicationResourceId = "/subscriptions/00c76877-e316-48a7-af60-4a09fec9d43f/resourceGroups/52F30DB2/providers/Microsoft.Solutions/applications/7E193158",
 *         JitAuthorizationPolicies = new[]
 *         {
 *             new AzureNative.Solutions.Inputs.JitAuthorizationPoliciesArgs
 *             {
 *                 PrincipalId = "1db8e132e2934dbcb8e1178a61319491",
 *                 RoleDefinitionId = "ecd05a23-931a-4c38-a52b-ac7c4c583334",
 *             },
 *         },
 *         JitRequestName = "myJitRequest",
 *         JitSchedulingPolicy = new AzureNative.Solutions.Inputs.JitSchedulingPolicyArgs
 *         {
 *             Duration = "PT8H",
 *             StartTime = "2021-04-22T05:48:30.6661804Z",
 *             Type = "Once",
 *         },
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/solutions/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := solutions.NewJitRequest(ctx, "jitRequest", &solutions.JitRequestArgs{
 * 			ApplicationResourceId: pulumi.String("/subscriptions/00c76877-e316-48a7-af60-4a09fec9d43f/resourceGroups/52F30DB2/providers/Microsoft.Solutions/applications/7E193158"),
 * 			JitAuthorizationPolicies: []solutions.JitAuthorizationPoliciesArgs{
 * 				{
 * 					PrincipalId:      pulumi.String("1db8e132e2934dbcb8e1178a61319491"),
 * 					RoleDefinitionId: pulumi.String("ecd05a23-931a-4c38-a52b-ac7c4c583334"),
 * 				},
 * 			},
 * 			JitRequestName: pulumi.String("myJitRequest"),
 * 			JitSchedulingPolicy: &solutions.JitSchedulingPolicyArgs{
 * 				Duration:  pulumi.String("PT8H"),
 * 				StartTime: pulumi.String("2021-04-22T05:48:30.6661804Z"),
 * 				Type:      pulumi.String("Once"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.solutions.JitRequest;
 * import com.pulumi.azurenative.solutions.JitRequestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jitRequest = new JitRequest("jitRequest", JitRequestArgs.builder()
 *             .applicationResourceId("/subscriptions/00c76877-e316-48a7-af60-4a09fec9d43f/resourceGroups/52F30DB2/providers/Microsoft.Solutions/applications/7E193158")
 *             .jitAuthorizationPolicies(Map.ofEntries(
 *                 Map.entry("principalId", "1db8e132e2934dbcb8e1178a61319491"),
 *                 Map.entry("roleDefinitionId", "ecd05a23-931a-4c38-a52b-ac7c4c583334")
 *             ))
 *             .jitRequestName("myJitRequest")
 *             .jitSchedulingPolicy(Map.ofEntries(
 *                 Map.entry("duration", "PT8H"),
 *                 Map.entry("startTime", "2021-04-22T05:48:30.6661804Z"),
 *                 Map.entry("type", "Once")
 *             ))
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:solutions:JitRequest myJitRequest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/jitRequests/{jitRequestName}
 * ```
 * @property applicationResourceId The parent application id.
 * @property jitAuthorizationPolicies The JIT authorization policies.
 * @property jitRequestName The name of the JIT request.
 * @property jitSchedulingPolicy The JIT request properties.
 * @property location Resource location
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags
 */
public data class JitRequestArgs(
    public val applicationResourceId: Output<String>? = null,
    public val jitAuthorizationPolicies: Output<List<JitAuthorizationPoliciesArgs>>? = null,
    public val jitRequestName: Output<String>? = null,
    public val jitSchedulingPolicy: Output<JitSchedulingPolicyArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.JitRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.JitRequestArgs =
        com.pulumi.azurenative.solutions.JitRequestArgs.builder()
            .applicationResourceId(applicationResourceId?.applyValue({ args0 -> args0 }))
            .jitAuthorizationPolicies(
                jitAuthorizationPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .jitRequestName(jitRequestName?.applyValue({ args0 -> args0 }))
            .jitSchedulingPolicy(
                jitSchedulingPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [JitRequestArgs].
 */
@PulumiTagMarker
public class JitRequestArgsBuilder internal constructor() {
    private var applicationResourceId: Output<String>? = null

    private var jitAuthorizationPolicies: Output<List<JitAuthorizationPoliciesArgs>>? = null

    private var jitRequestName: Output<String>? = null

    private var jitSchedulingPolicy: Output<JitSchedulingPolicyArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The parent application id.
     */
    @JvmName("bpepuvcspuvklolx")
    public suspend fun applicationResourceId(`value`: Output<String>) {
        this.applicationResourceId = value
    }

    /**
     * @param value The JIT authorization policies.
     */
    @JvmName("vsvurhwqdbebnwjp")
    public suspend fun jitAuthorizationPolicies(`value`: Output<List<JitAuthorizationPoliciesArgs>>) {
        this.jitAuthorizationPolicies = value
    }

    @JvmName("hnjwlquidvmsrxkv")
    public suspend fun jitAuthorizationPolicies(vararg values: Output<JitAuthorizationPoliciesArgs>) {
        this.jitAuthorizationPolicies = Output.all(values.asList())
    }

    /**
     * @param values The JIT authorization policies.
     */
    @JvmName("hqtgvcglpkoirila")
    public suspend fun jitAuthorizationPolicies(values: List<Output<JitAuthorizationPoliciesArgs>>) {
        this.jitAuthorizationPolicies = Output.all(values)
    }

    /**
     * @param value The name of the JIT request.
     */
    @JvmName("ytfuvthchmmtbghq")
    public suspend fun jitRequestName(`value`: Output<String>) {
        this.jitRequestName = value
    }

    /**
     * @param value The JIT request properties.
     */
    @JvmName("yjudikkjdpjjkjmr")
    public suspend fun jitSchedulingPolicy(`value`: Output<JitSchedulingPolicyArgs>) {
        this.jitSchedulingPolicy = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("paimwrwxgkrgmesv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qrdtltahreeottek")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("rsafccwkopdkqqwj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The parent application id.
     */
    @JvmName("yuakkqboomnnidyc")
    public suspend fun applicationResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationResourceId = mapped
    }

    /**
     * @param value The JIT authorization policies.
     */
    @JvmName("jmoixwfyucrqaacw")
    public suspend fun jitAuthorizationPolicies(`value`: List<JitAuthorizationPoliciesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jitAuthorizationPolicies = mapped
    }

    /**
     * @param argument The JIT authorization policies.
     */
    @JvmName("mumunufitivbwstb")
    public suspend
    fun jitAuthorizationPolicies(argument: List<suspend JitAuthorizationPoliciesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JitAuthorizationPoliciesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.jitAuthorizationPolicies = mapped
    }

    /**
     * @param argument The JIT authorization policies.
     */
    @JvmName("cpwcchgjhbdshsrj")
    public suspend fun jitAuthorizationPolicies(
        vararg
        argument: suspend JitAuthorizationPoliciesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JitAuthorizationPoliciesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.jitAuthorizationPolicies = mapped
    }

    /**
     * @param argument The JIT authorization policies.
     */
    @JvmName("fwjkikbcbbtyqyqs")
    public suspend
    fun jitAuthorizationPolicies(argument: suspend JitAuthorizationPoliciesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JitAuthorizationPoliciesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.jitAuthorizationPolicies = mapped
    }

    /**
     * @param values The JIT authorization policies.
     */
    @JvmName("ywswgmtrrigpmwuj")
    public suspend fun jitAuthorizationPolicies(vararg values: JitAuthorizationPoliciesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jitAuthorizationPolicies = mapped
    }

    /**
     * @param value The name of the JIT request.
     */
    @JvmName("jipddamyexgitwuf")
    public suspend fun jitRequestName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jitRequestName = mapped
    }

    /**
     * @param value The JIT request properties.
     */
    @JvmName("fflymrjbopggtwsy")
    public suspend fun jitSchedulingPolicy(`value`: JitSchedulingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jitSchedulingPolicy = mapped
    }

    /**
     * @param argument The JIT request properties.
     */
    @JvmName("bfjalehmuoiiklfx")
    public suspend
    fun jitSchedulingPolicy(argument: suspend JitSchedulingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = JitSchedulingPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jitSchedulingPolicy = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("ucsebbhpjhdaxepw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hvomqqreebgrravy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("plxutfhxgncmttoh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("jjxcjnitaovkibgw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): JitRequestArgs = JitRequestArgs(
        applicationResourceId = applicationResourceId,
        jitAuthorizationPolicies = jitAuthorizationPolicies,
        jitRequestName = jitRequestName,
        jitSchedulingPolicy = jitSchedulingPolicy,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
