@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ApplicationPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed application policy.
 * @property name The policy name
 * @property parameters The policy parameters.
 * @property policyDefinitionId The policy definition Id.
 */
public data class ApplicationPolicyArgs(
    public val name: Output<String>? = null,
    public val parameters: Output<String>? = null,
    public val policyDefinitionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ApplicationPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.ApplicationPolicyArgs =
        com.pulumi.azurenative.solutions.inputs.ApplicationPolicyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .policyDefinitionId(policyDefinitionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationPolicyArgs].
 */
@PulumiTagMarker
public class ApplicationPolicyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<String>? = null

    private var policyDefinitionId: Output<String>? = null

    /**
     * @param value The policy name
     */
    @JvmName("rsiuvsgsoxjdsjyu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The policy parameters.
     */
    @JvmName("bcidoddmsuuyiuxu")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value The policy definition Id.
     */
    @JvmName("yxgxvdcscwqgtmjt")
    public suspend fun policyDefinitionId(`value`: Output<String>) {
        this.policyDefinitionId = value
    }

    /**
     * @param value The policy name
     */
    @JvmName("cwxttrfcnbgmpooc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The policy parameters.
     */
    @JvmName("yxkystghmngvlesh")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The policy definition Id.
     */
    @JvmName("iomamrpgphhhgcbc")
    public suspend fun policyDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionId = mapped
    }

    internal fun build(): ApplicationPolicyArgs = ApplicationPolicyArgs(
        name = name,
        parameters = parameters,
        policyDefinitionId = policyDefinitionId,
    )
}
